ORCA/M Asm65816 2.1.0

0001 78D3                       TITLE 'Set System Speed & Slot Arbiter'
0002 78D3
0003 78D3              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 78D3              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 5:3:40 PM
0005 78D3
0006 78D3              ******************************************************
0007 78D3              *                                                    *
0008 78D3              *         Set System Speed & Slot Arbiter            *
0009 78D3              *                                                    *
0010 78D3              *                       by                           *
0011 78D3              *                    Ray Montagne                    *
0012 78D3              *                    Joe  Bo                         *
0013 78D3              *                                                    *
0014 78D3              *       Copyright Apple Computer, Inc. 1987-1989     *
0015 78D3              *                All Rights Reserved.                *
0016 78D3              *                                                    *
0017 78D3              ******************************************************
0018 78D3
0019 78D3              ;
0020 78D3              ; This routine sets the system speed in preparation for calling     
0021 78D3              ; a speed dependent device driver.  Speed settings are in the
0022 78D3              ; least significant two bits of the 'A' defined as follows:
0023 78D3              ; 
0024 78D3              ;    00  1.0 mhz
0025 78D3              ;    01  2.6 mhz
0026 78D3              ;    10  >2.6 mhz
0027 78D3              ;    11  not speed dependent (no change)
0028 78D3              ;
0029 78D3              ; Entry: via a 'JSL' and must be in 16 bit m/x
0030 78D3              ;    a = requested speed
0031 78D3              ;    x/y/b/d: undefined
0032 78D3              ;    p = n/v/m/x/d/i/z/c  e
0033 78D3              ;      = x/x/0/0/0/x/x/x  0
0034 78D3              ;
0035 78D3              ; Exit:
0036 78D3              ;    a = speed prior to requested change
0037 78D3              ;    x/y/b/d: undefined
0038 78D3              ;    p = n/v/m/x/d/i/z/c  e
0039 78D3              ;      = x/x/0/0/0/x/x/x  0
0040 78D3              ;
0041 78D3                                                      ; SEG $FF
0042 78D3              SETSPEED EQU   *
0043 78D3                                                      ; SEG $00
0044 78D3                       LONGA ON
0045 78D3                       LONGI ON
0046 78D3 29 03 00              AND   #$0003                   ;Mask unwanted bits
0047 78D6                       LONGA OFF
0048 78D6
0049 78D6 E2 20                 SEP   #$20                     ;8 bit 'm'
0050 78D8 A8                    TAY                            ;Save next speed setting
0051 78D9 AF 36 C0 00           LDA   >CYAREG                  ;Get current speed setting
0052 78DD 29 80                 AND   #$80                     ;
0053 78DF 18                    CLC                            ;
0054 78E0 2A                    ROL   A                        ;
0055 78E1 2A                    ROL   A                        ;
0056 78E2 AA                    TAX                            ;X = previous speed
0057 78E3 98                    TYA                            ;
0058 78E4 F0 15                 BEQ   SETSLOW                  ;
0059 78E6 C9 01                 CMP   #$01                     ;Set to fast speed ?
0060 78E8 F0 05                 BEQ   SETFAST                  ;
0061 78EA C9 03                 CMP   #$03                     ;NO change
0062 78EC F0 17                 BEQ   KEEPPRE                  ;
0063 78EE 3A                    DEC   A                        ; > 2.6 MHZ, can't do that yet !!!
0064 78EF              SETFAST  EQU   *
0065 78EF A9 80                 LDA   #$80                     ;Set fast speed
0066 78F1 0F 36 C0 00           ORA   >CYAREG                  ;
0067 78F5 8F 36 C0 00           STA   >CYAREG                  ;
0068 78F9 80 0A                 BRA   KEEPPRE                  ;bra to keep previous speed
0069 78FB
0070 78FB              SETSLOW  EQU   *
0071 78FB AF 36 C0 00           LDA   >CYAREG                  ;
0072 78FF 29 70                 AND   #$70                     ;Set slow speed
0073 7901 8F 36 C0 00           STA   >CYAREG                  ;
0074 7905              KEEPPRE  EQU   *
0075 7905 8A                    TXA                            ; Keep previous speed
0076 7906                       LONGA ON
0077 7906 C2 20                 REP   #$20                     ;Set back to 16 bit 'm'
0078 7908              SPEEDXIT EQU   *
0079 7908 29 03 00              AND   #$0003                   ;
0080 790B 6B                    RTL                            ;
0081 790C
0082 790C
0083 790C              ;
0084 790C              ; The following routine checks that a requested slot selection
0085 790C              ; is valid.  If so, the requested slot is selected and the
0086 790C              ; appropriate screen holes are copied in prior to passing
0087 790C              ; control back to the calling routine.
0088 790C              ;
0089 790C              ; NOTE: No dynamic slot selection occurs at this time
0090 790C              ;
0091 790C              ; Entry: via a 'JSL' through $E1 vector with 16 bit m/x
0092 790C              ;    a = requested slot
0093 790C              ;    x/y/b/d: undefined
0094 790C              ;    p = n/v/m/x/d/i/z/c  e
0095 790C              ;      = x/x/0/0/0/x/x/0  0
0096 790C              ;
0097 790C              ; Exit: via an 'rtl'
0098 790C              ;    a = error code
0099 790C              ;    x = slot configuration word
0100 790C              ;    y = unspecified
0101 790C              ;    b/d: unchanged
0102 790C              ;    p = n/v/m/x/d/i/z/c  e
0103 790C              ;        x/x/0/0/0/x/x/0  0   if slot was granted
0104 790C              ;        x/x/0/0/0/x/x/1  0   if slot was not granted
0105 790C              ;     
0106 790C                                                      ; SEG $FF
0107 790C              SLOTARBITER EQU   *
0108 790C                                                      ; SEG $00
0109 790C                       LONGA ON
0110 790C                       LONGI ON
0111 790C 8B                    PHB                            ;Save data bank
0112 790D 18                    CLC                            ;Assume no error
0113 790E A8                    TAY                            ;
0114 790F 29 00 03              AND   #$0300
0115 7912 D0 22                 BNE   EXIT
0116 7914 98                    TYA   
0117 7915
0118 7915                       LONGA OFF
0119 7915                       LONGI OFF
0120 7915 E2 30                 SEP   #$30                     ;8 bit m/x
0121 7917 AA                    TAX                            ;Save user's requested slot
0122 7918 29 07                 AND   #$07                     ;Strip external bit
0123 791A F0 19                 BEQ   BADSEL                   ;
0124 791C C9 03                 CMP   #$03                     ;Slot 3 is a special case
0125 791E F0 34                 BEQ   SLOT3REQ                 ;
0126 7920 A8                    TAY                            ;Is current slot external ?
0127 7921 AF 2D C0 00           LDA   >SLTROMSEL               ;
0128 7925              LOOP     EQU   *
0129 7925 6A                    ROR   A
0130 7926 88                    DEY                            ;
0131 7927 10 FC                 BPL   LOOP                     ;C=1 if external on loop exit
0132 7929              CHECKSLOT EQU   *
0133 7929 8A                    TXA                            ;Get back user's slot request
0134 792A 29 08                 AND   #$08                     ;
0135 792C B0 05                 BCS   CHKXIT                   ;YES
0136 792E D0 05                 BNE   BADSEL                   ;If is int but requested ext
0137 7930
0138 7930              GOODSEL  EQU   *
0139 7930 18                    CLC                            ;
0140 7931 80 03                 BRA   EXIT
0141 7933
0142 7933              CHKXIT   EQU   *
0143 7933 D0 FB                 BNE   GOODSEL                  ;
0144 7935              BADSEL   EQU   *
0145 7935 38                    SEC                            ;
0146 7936              EXIT     EQU   *
0147 7936 E2 20                 SEP   #$20                     ;Get us back into 8 bit mode 3/23/89 MSA
0148 7938 08                    PHP                            ;Save 'c'
0149 7939 AF 2D C0 00           LDA   >SLTROMSEL               ;Get slot
0150 793D 48                    PHA   
0151 793E EB                    XBA   
0152 793F 68                    PLA   
0153 7940 28                    PLP   
0154 7941                       LONGA ON
0155 7941                       LONGI ON
0156 7941 C2 30                 REP   #$30
0157 7943 49 FF 00              EOR   #$00FF                   ;Create slot configuration word
0158 7946 29 FE FE              AND   #$FEFE
0159 7949 AA                    TAX   
0160 794A A9 00 00              LDA   #$0000                   ;Assume no error first
0161 794D 90 03                 BCC   REALEXIT                 ;
0162 794F A9 10 00              LDA   #$0010                   ;Error code
0163 7952              REALEXIT EQU   *
0164 7952 AB                    PLB   
0165 7953 6B                    RTL   
0166 7954              SLOT3REQ EQU   *
0167 7954                       LONGA OFF
0168 7954                       LONGI OFF
0169 7954 AF 17 C0 00           LDA   >RDC3ROM                 ;Need slot 3 selection
0170 7958 2A                    ROL   A                        ;
0171 7959 80 CE                 BRA   CHECKSLOT                ;C=1 if slot 3 is external
0172 795B
0173 795B              *
0174 795B              * The set_default_slots and restore_system_slots are used in 
0175 795B              * interrupt codes.  
0176 795B              * Not yet implemented in this version.   
0177 795B              * 
0178 795B                                                      ; SEG $FF
0179 795B              SETDEFSLT EQU   *
0180 795B                                                      ; SEG $00
0181 795B
0182 795B                                                      ; SEG $FF
0183 795B              RSTSYSSLT EQU   *
0184 795B                                                      ; SEG $00
0185 795B 6B                    RTL                            ;
0186 795C
0187 795C
0188 795C
0189 795C                       TITLE 'Some Stuff Called/Used by Desk Acc'
0190 795C
0191 795C              * TP2TASK is called by the heartbeat task scheduler
0192 795C              * to move text page 2 from bank 00 to bank E1.
0193 795C
0194 795C                                                      ; SEG $FF
0195 795C              TP2TASK  EQU   *                        ;Task to copy text page 2 to bank E0
0196 795C                                                      ; SEG $00
0197 795C A9 01                 LDA   #$01                     ;Reset task counter
0198 795E 8F 74 01 E1           STA   >TP2TCNT                 ;Low byte is sufficient
0199 7962                       LONGA ON
0200 7962                       LONGI ON
0201 7962 C2 30                 REP   #$30                     ;16 bit land required for routine
0202 7964 A2 00 08              LDX   #$0800                   ;Starting address of move in source bank
0203 7967 9B                    TXY                            ;Starting addr of move in destination bank
0204 7968 A9 FF 03              LDA   #$0400-1                 ;Number of bytes to move-1
0205 796B 54 E0 00              MVN   $000000,$E00000          ;Source,destination banks
0206 796E                       LONGI OFF
0207 796E                       LONGA OFF
0208 796E 6B                    RTL                            ;Back to heartbeat handler with task done
0209 796F
0210 796F
0211 796F
0212 796F              * ENMONDSKACC is called by the user pressing
0213 796F              * '#' as a command in the monitor.  It installs
0214 796F              * a desk accessory which allows the user to
0215 796F              * enter the monitor from the desk accessories
0216 796F              * menu and return to it with a control-Y.
0217 796F              * It also installs the memory peeker desk accessory.
0218 796F
0219 796F              ENMONDSKACC EQU   *                     ;Enable the monitor desk accessory
0220 796F AF 7D 01 E1           LDA   >ROMDAACT
0221 7973 09 80                 ORA   #$80                     ;
0222 7975 8F 7D 01 E1           STA   >ROMDAACT                ;
0223 7979              ENMONDSKACC1 EQU   *
0224 7979 AF 7D 01 E1           LDA   >ROMDAACT                ;Test if already active
0225 797D 48                    PHA   
0226 797E 0A                    ASL   A                        ;Bit7=1=install it--Bit6=1=is installed
0227 797F 30 15                 BMI   ENROMDA                  ;Already installed if bit is set
0228 7981 C2 30                 REP   #$30                     ;16 bit land required for call
0229 7983 F4 FF 00              PEA   PTRDAINFOTBL>>16         ;Bank #
0230 7986 F4 9E 79              PEA   PTRDAINFOTBL             ;Address
0231 7989                       LONGI ON
0232 7989 A2 05 0F              LDX   #INSTALLCDA              ;Tool # and function for call
0233 798C                       LONGI OFF
0234 798C 22 00 00 E1           JSL   >DISPATCH1               ;Make call to install desk accessory
0235 7990 22 04 00 FE           JSL   >MEMORYPEEKER            ;Install memory peeker too
0236 7994 E2 30                 SEP   #$30                     ;Return in 8 bit mode
0237 7996              ENROMDA  EQU   *
0238 7996 68                    PLA                            ;
0239 7997 09 40                 ORA   #$40                     ;Say that monitor/memory peeker installed
0240 7999 8F 7D 01 E1           STA   >ROMDAACT                ; and active.
0241 799D 60                    RTS                            ;Back to caller with desk acc installed
0242 799E
0243 799E
0244 799E                                                      ; SEG $FF
0245 799E              PTRDAINFOTBL EQU   *
0246 799E                                                      ; SEG $00
0247 799E A2 79                 DC W:DAINFOTBL                 ;
0248 79A0 FF 00                 DC W:DAINFOTBL>>16             ;
0249 79A2
0250 79A2
0251 79A2                                                      ; SEG $FF
0252 79A2              DAINFOTBL EQU   *
0253 79A2                                                      ; SEG $00
0254 79A2 0D D6 E9 F3           DC C:'Visit Monitor'
0255 79B0 B8 79                 DC W:REALCODE                  ;Address of code
0256 79B2 FF 00                 DC W:REALCODE>>16              ;Bank number of code
0257 79B4 24 7A                 DC W:SHUTDOWN                  ;Address of shutdown routine
0258 79B6 FF 00                 DC W:SHUTDOWN>>16              ;Bank number of shutdown routine
0259 79B8
0260 79B8
0261 79B8                                                      ; SEG $FF
0262 79B8              REALCODE EQU   *
0263 79B8                                                      ; SEG $00
0264 79B8 E2 30                 SEP   #$30                     ;Switch to 8 bit native mode
0265 79BA 78                    SEI                            ;Kill interrupts in here
0266 79BB F4 00 00              PEA   $0000                    ;Change data bank register to $00
0267 79BE AB                    PLB                            ;
0268 79BF AB                    PLB                            ;
0269 79C0
0270 79C0 A2 02                 LDX   #$02                     ;Save 3 bytes
0271 79C2              @0       EQU   *
0272 79C2 BD F8 03              LDA   |USRADR,X                ;Save CTRL-Y vector information
0273 79C5 48                    PHA                            ;
0274 79C6 CA                    DEX                            ;
0275 79C7 10 F9                 BPL   @0                       ;Loop til done
0276 79C9
0277 79C9 A9 4C                 LDA   #$4C                     ;JMP opcode
0278 79CB 8D F8 03              STA   |USRADR                  ;
0279 79CE A9 FB                 LDA   #<RETURNFROM             ;Put in CTL-Y hook
0280 79D0 8D F9 03              STA   |USRADR+1                ;
0281 79D3 9C FA 03              STZ   |USRADR+2                ;High byte is $00
0282 79D6
0283 79D6
0284 79D6 A2 08                 LDX   #GOINFOLEN-1             ;Number of bytes-1 to save
0285 79D8              @1       EQU   *
0286 79D8 B5 F7                 LDA   GOTOMON,X                ;Save zero page
0287 79DA 48                    PHA                            ;
0288 79DB CA                    DEX                            ;
0289 79DC 10 FA                 BPL   @1                       ;Loop til done
0290 79DE
0291 79DE
0292 79DE 8B                    PHB                            ;
0293 79DF 4B                    PHK                            ;
0294 79E0 AB                    PLB                            ;
0295 79E1 A2 08                 LDX   #GOINFOLEN-1             ;Move 9 bytes for hooks
0296 79E3              @11      EQU   *
0297 79E3 BD 25 7A              LDA   GOINFO,X                 ;
0298 79E6 95 F7                 STA   GOTOMON,X                ;
0299 79E8 CA                    DEX                            ;
0300 79E9 10 F8                 BPL   @11                      ;Loop til done
0301 79EB AB                    PLB                            ;
0302 79EC
0303 79EC
0304 79EC 4B                    PHK                            ;Set up return bank
0305 79ED 68                    PLA                            ;
0306 79EE 85 FF                 STA   RETURNBANK               ;
0307 79F0
0308 79F0
0309 79F0 AD 68 C0              LDA   STATEREG                 ;Save state register while
0310 79F3 48                    PHA                            ; clearing screen.
0311 79F4 20 EE A9              JSR   HOMEFF                   ;Clear screen
0312 79F7
0313 79F7
0314 79F7 A9 F2                 LDA   #WELCOME                 ;
0315 79F9 20 80 C0              JSR   PRINTMSG                 ;8 bit entry to print message routine
0316 79FC
0317 79FC
0318 79FC 68                    PLA                            ;Restore INTCXROM/SLOTCXROM status
0319 79FD 8D 68 C0              STA   STATEREG                 ; by restoring state register.
0320 7A00
0321 7A00
0322 7A00 38                    SEC                            ;Must go to monitor in emulation mode
0323 7A01 FB                    XCE                            ;Interrupts are off so it's OK here
0324 7A02 5C F7 00 00           JMP   >GOTOMON                 ;Go into monitor (Turns on interrupts)
0325 7A06
0326 7A06
0327 7A06              RETURNPOINT EQU   *                     ;Interrupts are disabled on entry to here
0328 7A06 68                    PLA                            ;Remove monitor's CTRL-Y return address
0329 7A07 68                    PLA                            ;
0330 7A08 F4 00 00              PEA   $0000                    ;Restore data bank register to $00
0331 7A0B AB                    PLB                            ;
0332 7A0C AB                    PLB                            ;
0333 7A0D 18                    CLC                            ;Must return to native mode
0334 7A0E FB                    XCE                            ;
0335 7A0F 58                    CLI                            ; and reenable interrupts.
0336 7A10 A2 00                 LDX   #$00                     ;Restore zero page
0337 7A12              @2       EQU   *
0338 7A12 68                    PLA                            ;
0339 7A13 95 F7                 STA   GOTOMON,X                ;
0340 7A15              @4       EQU   *
0341 7A15 E8                    INX                            ;
0342 7A16 E0 09                 CPX   #GOINFOLEN               ;If at GOINFOLEN then done
0343 7A18 90 F8                 BCC   @2                       ;Loop til done
0344 7A1A
0345 7A1A 68                    PLA                            ;Recall USRADR (CTRL-Y) information
0346 7A1B 9D EF 03              STA   |USRADR-9,X              ; and save it.
0347 7A1E E0 0B                 CPX   #GOINFOLEN+2             ;Done if matches
0348 7A20 90 F3                 BCC   @4                       ;Loop til done
0349 7A22
0350 7A22
0351 7A22 C2 30                 REP   #$30                     ;MUST return in 16 bit mode
0352 7A24
0353 7A24                                                      ; SEG $FF
0354 7A24              SHUTDOWN EQU   *                        ;No action required for the shutdown rtne
0355 7A24                                                      ; SEG $00
0356 7A24 6B                    RTL                            ;Return to calling program
0357 7A25
0358 7A25
0359 7A25              GOINFO   EQU   *
0360 7A25 58 4C                 DC B:$58,$4C                   ;Enable interrupts before entering monitor
0361 7A27 69 FF                 DC W:MONZ                      ;
0362 7A29 78 5C                 DC B:$78,$5C                   ;SEI and JMP abslong
0363 7A2B 06 7A                 DC W:RETURNPOINT               ;
0364 7A2D 00                    DC B:$00                       ;Return bank number patched in zero pg
0365 7A2E              GOINFOLEN EQU   *-GOINFO                ;Number of bytes to move
0366 7A2E
0367 7A2E
0368 7A2E
0369 7A2E
0370 7A2E              * A routine to set text page2 shadowing register ($c035, bit5)
0371 7A2E              * probably for original //gs and new machine
0372 7A2E              * For gs, when exit 'c'=0 else 'c'=1
0373 7A2E
0374 7A2E                                                      ; SEG $FF
0375 7A2E              SETTEXT2REG EQU   *
0376 7A2E                                                      ; SEG $00
0377 7A2E 8B                    PHB                            ; Save data bank
0378 7A2F 20 82 F8              JSR   DBTOE1                   ;Set to $e1 bank
0379 7A32 AD 8E 01              LDA   |KEYUCVER                ;Get keyucver #
0380 7A35 C9 06                 CMP   #$06                     ;If > $06, then using new CYA chip
0381 7A37 90 0C                 BCC   @2                       ;Bra if not, old FPI chip
0382 7A39 AD 7C 01              LDA   |TP2MODE                 ;Chk for already on/off
0383 7A3C D0 07                 BNE   @2                       ;Bra if already off
0384 7A3E A9 20                 LDA   #$20                     ;Else it is on, need to turn off
0385 7A40 0C 35 C0              TSB   SHADOW                   ;Set off
0386 7A43 80 05                 BRA   @3                       ;Bra to end 
0387 7A45
0388 7A45              @2       EQU   *
0389 7A45 A9 20                 LDA   #$20                     ;Previous on is off, set on now
0390 7A47 1C 35 C0              TRB   SHADOW                   ;Set on, no effect for gs board
0391 7A4A AB           @3       PLB                            ;Restore data bank
0392 7A4B 60                    RTS                            ;Return to caller
0393 7A4C
0394 7A4C
0395 7A4C              *
0396 7A4C              * This routine (placed here due to space constraints) assists
0397 7A4C              *  in the execution of the 'G' & 'X' commands by taking the
0398 7A4C              *  value of the user's M & X bits and folding them into the 
0399 7A4C              *  processor status byte so that they will correctly determine
0400 7A4C              *  the state of the M & X bits at the beginning of the execution
0401 7A4C              *  of the user's code.  The DBR must already point to $E1 on
0402 7A4C              *  entry and the environment must be '8 bit native'.
0403 7A4C              *
0404 7A4C              * The code was taken from the 01 ROM... {3/31/89 MSA & John A}
0405 7A4C              *
0406 7A4C              ;INDEX8
0407 7A4C              ;MEMORY8 both not necessary
0408 7A4C              COMBINEMX EQU   *
0409 7A4C 08                    PHP   
0410 7A4D E2 30                 SEP   #$30                     ;Force for this routine... restored at plp!
0411 7A4F AD 30 01              LDA   |MPVAL                   ;0000000M Get user desired M state
0412 7A52 0A                    ASL   a                        ;000000M0           
0413 7A53 0D 31 01              ORA   |XPVAL                   ;000000MX                       
0414 7A56 0A                    ASL   a                        ;00000MX0
0415 7A57 0A                    ASL   a                        ;0000MX00
0416 7A58 0A                    ASL   a                        ;000MX000
0417 7A59 0A                    ASL   a                        ;00MX0000 Right where we want it
0418 7A5A 48                    PHA   
0419 7A5B AD 2A 01              LDA   |PVAL                    ;Get back the other status bits
0420 7A5E 29 CF                 AND   #$CF                     ;Clear a hole for the MX bits
0421 7A60 03 01                 ORA   1,s                      ;Combine
0422 7A62 7A                    PLY                            ;Clean up the stack
0423 7A63 8D 2A 01              STA   |PVAL
0424 7A66 28                    PLP                            ;Pull back our execution environment
0425 7A67 60                    RTS   
0426 7A68              *
0427 7A68              *
0428 7A68                       LONGA OFF
0429 7A68                       LONGI OFF
0430 7A68              ;
0431 7A68              ; RESTOREFF: M, Q, e, P, B, D, Y, X AND A
0432 7A68              ;
0433 7A68              RESTOREFF EQU   *
0434 7A68 F4 E1 E1              PEA   $E1E1
0435 7A6B AB                    PLB   
0436 7A6C AB                    PLB                            ;Change data bank to $e1
0437 7A6D AD 1C C0              LDA   |RDPAGE2                 ;Page2, set/clr by user
0438 7A70 10 07                 BPL   P2OFF                    ;Bra if p2 off
0439 7A72 AD 2D 01              LDA   |MVAL                    ;Memory status value
0440 7A75 09 40                 ORA   #$40                     ;Set p2 on
0441 7A77 80 05                 BRA   SETP2
0442 7A79              P2OFF    EQU   *
0443 7A79 AD 2D 01              LDA   |MVAL
0444 7A7C 29 BF                 AND   #$BF                     ;Set p2 off
0445 7A7E              SETP2    EQU   *
0446 7A7E 8D 68 C0              STA   |STATEREG                ;Update the STATEREG, $c068
0447 7A81
0448 7A81 AD 2E 01              LDA   |QVAL                    ;bit7=speed, bit6-0, match shadow reg
0449 7A84 0A                    ASL   A                        ;Speed to 'c'
0450 7A85 08                    PHP                            ;Temporary save this 'c'=speed
0451 7A86 AD 36 C0              LDA   |CYAREG                  ;$C036
0452 7A89 0A                    ASL   A                        ;Original speed to c
0453 7A8A 28                    PLP                            ;Get back new speed in c
0454 7A8B 6A                    ROR   A                        ;Rotate to $C036 position with new speed 
0455 7A8C 29 9F                 AND   #$9F                     ;Bit 6/5 must write 0
0456 7A8E 8D 36 C0              STA   |CYAREG                  ;Update it
0457 7A91
0458 7A91 AD 2E 01              LDA   |QVAL
0459 7A94 29 5F                 AND   #$5F                     ;Bit7/5 must write 0
0460 7A96 8D 35 C0              STA   |SHADOW                  ;Update shadow reg, $c035
0461 7A99
0462 7A99 AD 32 01              LDA   |EPVAL                   ;Get back e
0463 7A9C 6A                    ROR   A                        ;'e' into carry
0464 7A9D AD 2A 01              LDA   |PVAL                    ;Get back user's processor status
0465 7AA0 09 04                 ORA   #$04                     ;Disable interrupts {MSA 4/6/89}
0466 7AA2 EB                    XBA                            ;High byte = PVAL, low byte = data bank
0467 7AA3 AD 2B 01              LDA   |BVAL
0468 7AA6
0469 7AA6 C2 30                 REP   #$30                     ;Off to 16 bit land
0470 7AA8                       LONGA ON
0471 7AA8                       LONGI ON
0472 7AA8 48                    PHA                            ;Push PVAL and data bank value to stack
0473 7AA9 AD 28 01              LDA   |DVAL                    ;Restore user's direct register 
0474 7AAC 5B                    TCD   
0475 7AAD AC 24 01              LDY   |YVAL                    ;Restore user's 'Y'
0476 7AB0 AE 22 01              LDX   |XVAL                    ;Restore user's 'X'
0477 7AB3 AD 20 01              LDA   |AVAL                    ;Restore user's 'A'
0478 7AB6
0479 7AB6 AB                    PLB                            ;Reset to user's data bank, from BVAL
0480 7AB7 90 09                 BCC   USERE0                   ;Bra for user e=0       
0481 7AB9 28                    PLP                            ;Restore user's P status
0482 7ABA 90 03                 BCC   USERC0                   ;Bra for user e=0, c=0
0483 7ABC 38                    SEC                            ;User's 'c'=1
0484 7ABD 80 07                 BRA   USERC1                   ;Bra for user e=0, c=1
0485 7ABF
0486 7ABF              USERC0   EQU   *
0487 7ABF 38                    SEC   
0488 7AC0 80 09                 BRA   USERE1
0489 7AC2
0490 7AC2              USERE0   EQU   *
0491 7AC2 28                    PLP   
0492 7AC3 90 05                 BCC   USERC0E0
0493 7AC5 18                    CLC   
0494 7AC6              USERC1   EQU   *
0495 7AC6 FB                    XCE   
0496 7AC7 38                    SEC   
0497 7AC8 80 03                 BRA   USERC1E1
0498 7ACA
0499 7ACA              USERC0E0 EQU   *
0500 7ACA 18                    CLC   
0501 7ACB              USERE1   EQU   *
0502 7ACB FB                    XCE   
0503 7ACC 18                    CLC   
0504 7ACD
0505 7ACD              USERC1E1 EQU   *
0506 7ACD 60                    RTS                            ;Return to caller
0507 7ACE              ;
0508 7ACE              ; STOREFF: e, P, B, D, S, A, X, Y, M AND Q
0509 7ACE              ;
0510 7ACE              STOREFF  EQU   *
0511 7ACE 8F 20 01 E1           STA   >AVAL                    ;Save low A (& high if e,m=0)
0512 7AD2 08                    PHP                            ;Save P
0513 7AD3                       LONGA OFF
0514 7AD3 E2 20                 SEP   #$20                     ;Off to 8 bit A
0515 7AD5 68                    PLA                            ;'P' in low A
0516 7AD6              *
0517 7AD6              * Since we could not let the user have interrupts on during the
0518 7AD6              *  execution of his instruction, we must force them back on here.
0519 7AD6              *  {MSA 4/12/89} 
0520 7AD6              *
0521 7AD6 29 FB                 AND   #$FB                     ;Force off I bit which enables interrupts
0522 7AD8              *
0523 7AD8 8F 2A 01 E1           STA   >PVAL
0524 7ADC 18                    CLC   
0525 7ADD FB                    XCE                            ;Native (user e into carry)
0526 7ADE D8                    CLD                            ;No decimal mode
0527 7ADF                       LONGA OFF
0528 7ADF E2 20                 SEP   #$20                     ;8 bit A
0529 7AE1 EB                    XBA   
0530 7AE2 8F 21 01 E1           STA   >AVAL+1                  ;Save high A (if e or m was = 1)
0531 7AE6
0532 7AE6 A9 00                 LDA   #$00
0533 7AE8 2A                    ROL   A                        ;User's e to lsb
0534 7AE9 8F 32 01 E1           STA   >EPVAL                   ;Store it for display
0535 7AED
0536 7AED 8B                    PHB                            ;Save user data bank
0537 7AEE 68                    PLA   
0538 7AEF 8F 2B 01 E1           STA   >BVAL
0539 7AF3
0540 7AF3                       LONGA ON
0541 7AF3                       LONGI ON
0542 7AF3 C2 30                 REP   #$30                     ;Off to 16 bit land
0543 7AF5 20 82 F8              JSR   DBTOE1                   ;Change data bank to $e1
0544 7AF8 7B                    TDC                            ;Get user's direct register
0545 7AF9 8D 28 01              STA   |DVAL                    ;Store it
0546 7AFC 8E 22 01              STX   |XVAL                    ;       
0547 7AFF 8C 24 01              STY   |YVAL                    ;        
0548 7B02
0549 7B02                       LONGA OFF
0550 7B02                       LONGI OFF
0551 7B02 E2 30                 SEP   #$30
0552 7B04
0553 7B04 AD 2A 01              LDA   |PVAL                    ;Fix 'm'/'x' for print registers
0554 7B07 29 30                 AND   #$30
0555 7B09 4A                    LSR   A                        ;Shift 'x' into 'c' and 'm' into bit0
0556 7B0A 20 7B F8              JSR   SCRN4                    ;Shift right 4 times, use user stack area
0557 7B0D 8D 30 01              STA   |MPVAL                   ;Store new 'm' value
0558 7B10 A9 00                 LDA   #$00
0559 7B12 2A                    ROL   A                        ;
0560 7B13 8D 31 01              STA   |XPVAL                   ;Store new 'x' value
0561 7B16
0562 7B16 AD 68 C0              LDA   |STATEREG                ;Get machine state
0563 7B19 8D 2D 01              STA   |MVAL                    ;Store to print buffer for display
0564 7B1C 29 04                 AND   #$04                     ;Mask for language card bank for LVAL
0565 7B1E 4A                    LSR   A                        ;Shift bit2 (LC bank) to bit0
0566 7B1F 4A                    LSR   A                        ;
0567 7B20 8D 2F 01              STA   |LVAL                    ;Store for display
0568 7B23
0569 7B23 AD 36 C0              LDA   |CYAREG                  ;Get speed
0570 7B26 0A                    ASL   A                        ;Speed to 'c'
0571 7B27 08                    PHP                            ;Save 'c'
0572 7B28 AD 35 C0              LDA   |SHADOW                  ;
0573 7B2B 0A                    ASL   A
0574 7B2C 28                    PLP                            ;Get back speed
0575 7B2D 6A                    ROR   A                        ;Rotate to MSB
0576 7B2E 8D 2E 01              STA   |QVAL
0577 7B31 29 5F                 AND   #$5F                     ;Strip off speed
0578 7B33 8D 35 C0              STA   |SHADOW                  ;
0579 7B36
0580 7B36 AD 36 C0              LDA   |CYAREG
0581 7B39 09 80                 ORA   #$80
0582 7B3B 8D 36 C0              STA   |CYAREG                  ;Go fast
0583 7B3E
0584 7B3E F4 00 00              PEA   $0000                    ;Set monitor direct reg, $0000
0585 7B41 2B                    PLD                            ;Reset direct register
0586 7B42 F4 00 00              PEA   $0000                    ;Reset monitor data bank, $00  
0587 7B45 AB                    PLB                            ;Reset data bank
0588 7B46 AB                    PLB   
0589 7B47 60                    RTS                            ;Back to monitor's for display user's regs
0590 7B48              *
0591 7B48              *
0592 7B48              *
0593 7B48              STACKFUTZ EQU   *
0594 7B48              *
0595 7B48              * This routine stores the value of the emulation stack pointer PLUS TWO
0596 7B48              *  at the emulation stack pointer storage location $010100.  The
0597 7B48              *  plus two covers the rts which is done at the end of the routine.
0598 7B48              *  This routine is called in four places by routines in MISC.MON.aii
0599 7B48              *  {MSA 4/28/89}
0600 7B48              *
0601 7B48 AF 00 01 01           LDA   >MNEMSTKPTR              ;Get the old value
0602 7B4C 8F CF 01 E1           STA   >KPMNEMSP                ; and keep 'til later
0603 7B50 3B                    TSC                            ;Get current pointer
0604 7B51 1A                    INC   a
0605 7B52 1A                    INC   a
0606 7B53 8F 00 01 01           STA   >MNEMSTKPTR
0607 7B57 60                    RTS   
0608 7B58              *
